//
// SPINNER - spinning rainbow SPX library
//
// Version 1.0 10/04/91 Copyright (C) 91 Lantern Corp.
// Author: Edward Hutchins
// Revisions:
// 10/09/91 moved from smplspx to spinner (prettied up) - Ed.
//

#include "spinner.h"

//
// globals
//

GLOBAL HANDLE       hLibInst;                           // current instance
GLOBAL INT          nColorCnt;                          // number of colors
GLOBAL BOOL         bEnabled;                           // SPX enable switch
GLOBAL TRI          triBlank;                           // blank screen first
GLOBAL TRI          triSpin;                            // spin it up!
GLOBAL TRI          triSolid;                           // fill it in!
GLOBAL CHAR         szAppName[] = "Screen Peace";       // saver app name
GLOBAL CHAR         szSaverName[] = "Spinner";          // SPX name
GLOBAL CHAR         szProfColor[] = "Spinner Colors";   // profiler key
GLOBAL CHAR         szProfEnabled[] = "Spinner On";     // profiler key
GLOBAL CHAR         szProfBlank[] = "Spinner Blank";    // profiler key
GLOBAL CHAR         szProfSpin[] = "Spinner Spin";      // profiler key
GLOBAL CHAR         szProfSolid[] = "Spinner Solid";    // profiler key

//
// GetProfileTri - get a tri-state variable from the profile
//

TRI NEAR PASCAL GetProfileTri( LPSTR lpszKey )
{
	GLOBAL CHAR         szBuff[64];

	GetProfileString( szAppName, lpszKey, "u", szBuff, sizeof(szBuff) );
	switch (szBuff[0])
	{
	case 'N': case 'n':
		return( TRI_FALSE );
	case 'Y': case 'y':
		return( TRI_TRUE );
	default:
		return( TRI_UNSET );
	}
}

//
// WriteProfileTri - write a tri-state variable to the profile
//

BOOL NEAR PASCAL WriteProfileTri( LPSTR lpszKey, TRI tri )
{
	switch (tri)
	{
	case TRI_FALSE:
		return( WriteProfileString( szAppName, lpszKey, "n" ) );
	case TRI_TRUE:
		return( WriteProfileString( szAppName, lpszKey, "y" ) );
	default:
		return( WriteProfileString( szAppName, lpszKey, "u" ) );
	}
}

//
// WriteProfileInt - write an integer to the profile
//

BOOL NEAR PASCAL WriteProfileInt( LPSTR lpszKey, INT nVal )
{
	GLOBAL CHAR         szBuff[64];

	wsprintf( szBuff, "%u", nVal );
	return( WriteProfileString( szAppName, lpszKey, szBuff ) );
}

//
// LibMain - initialize the local data segment
//

BOOL FAR PASCAL EXPORT LibMain( HANDLE hInstance, WORD wDataSeg,
								WORD wHeapSize, LPSTR szCmdLine )
{
	hLibInst = hInstance;
	nColorCnt = GetProfileInt( szAppName, szProfColor, PALETTE_SIZE );
	bEnabled = GetProfileTri( szProfEnabled );
	triBlank = GetProfileTri( szProfBlank );
	triSpin = GetProfileTri( szProfSpin );
	triSolid = GetProfileTri( szProfSolid );
	UnlockData( 0 );
	return( TRUE );
}

//
// WEP - Windows Exit Procedure, clean up resources
//

int FAR PASCAL EXPORT WEP( BOOL bSystemExit )
{
}

//
// SaverInit - register with Screen Peace
//

LPSTR FAR PASCAL EXPORT SaverInit( LPBOOL lpbEnabled )
{
	*lpbEnabled = bEnabled;
	return( szSaverName );
}

//
// SaverDlgProc - dialog proc for user customization
//

BOOL FAR PASCAL EXPORT SaverDlgProc( HWND hdlg, WORD mess, WORD wP, LONG lP )
{
	switch (mess)
	{
	case WM_INITDIALOG:
		SetDlgItemInt( hdlg, IDD_S_COLOR, nColorCnt, FALSE );
		SendDlgItemMessage( hdlg, IDD_S_ENABLE, BM_SETCHECK, bEnabled, 0 );
		SendDlgItemMessage( hdlg, IDD_S_BLANK, BM_SETCHECK, triBlank, 0 );
		SendDlgItemMessage( hdlg, IDD_S_SPIN, BM_SETCHECK, triSpin, 0 );
		SendDlgItemMessage( hdlg, IDD_S_SOLID, BM_SETCHECK, triSolid, 0 );
		return( TRUE );

	case WM_COMMAND:
		switch (wP)
		{
		case IDOK:
			nColorCnt = GetDlgItemInt( hdlg, IDD_S_COLOR, NULL, FALSE );
			bEnabled = (BOOL)SendDlgItemMessage( hdlg, IDD_S_ENABLE, BM_GETCHECK, 0, 0 );
			triBlank = (TRI)SendDlgItemMessage( hdlg, IDD_S_BLANK, BM_GETCHECK, 0, 0 );
			triSpin = (TRI)SendDlgItemMessage( hdlg, IDD_S_SPIN, BM_GETCHECK, 0, 0 );
			triSolid = (TRI)SendDlgItemMessage( hdlg, IDD_S_SOLID, BM_GETCHECK, 0, 0 );
			WriteProfileTri( szProfEnabled, bEnabled );
			if (bEnabled)
			{
				WriteProfileInt( szProfColor, nColorCnt );
				WriteProfileTri( szProfBlank, triBlank );
				WriteProfileTri( szProfSpin, triSpin );
				WriteProfileTri( szProfSolid, triSolid );
			}
			EndDialog( hdlg, TRUE );
			return( TRUE );

		case IDCANCEL:
			EndDialog( hdlg, FALSE );
			return( TRUE );
		}
		break;
	}
	return( FALSE );
}
